@REM @file
@REM
@REM @copyright
@REM  INTEL CONFIDENTIAL
@REM  Copyright 2014 - 2017 Intel Corporation.
@REM
@REM  The source code contained or described herein and all documents related to the
@REM  source code ("Material") are owned by Intel Corporation or its suppliers or
@REM  licensors. Title to the Material remains with Intel Corporation or its suppliers
@REM  and licensors. The Material may contain trade secrets and proprietary and
@REM  confidential information of Intel Corporation and its suppliers and licensors,
@REM  and is protected by worldwide copyright and trade secret laws and treaty
@REM  provisions. No part of the Material may be used, copied, reproduced, modified,
@REM  published, uploaded, posted, transmitted, distributed, or disclosed in any way
@REM  without Intel's prior express written permission.
@REM
@REM  No license under any patent, copyright, trade secret or other intellectual
@REM  property right is granted to or conferred upon you by disclosure or delivery
@REM  of the Materials, either expressly, by implication, inducement, estoppel or
@REM  otherwise. Any license under such intellectual property rights must be
@REM  express and approved by Intel in writing.
@REM
@REM  Unless otherwise agreed by Intel in writing, you may not remove or alter
@REM  this notice or any other notice embedded in Materials by Intel or
@REM  Intel's suppliers or licensors in any way.
@REM
@REM  This file contains a 'Sample Driver' and is licensed as such under the terms
@REM  of your license agreement with Intel or your vendor. This file may be modified
@REM  by the user, subject to the additional terms of the license agreement.
@REM
@REM @par Specification Reference:
@REM

@echo OFF
@set PrepRELEASE=DEBUG
@set SILENT_MODE=FALSE
@set CapsuleBuild=FALSE

@rem
@rem PlatformPkgExtConfig.dsc is used in build. It will be cleared here.
@rem EXT_BUILD_FLAGS is used by prep.bat and bld.bat. It will cleared in the
@rem beginning of prep.bat and not cleared after bld.bat. It is not suppose
@rem to be modified by bld.bat. This will ensure bld.bat can have incremental
@rem build with all correct flags intact.
@rem
@if exist PlatformPkgExtConfig.dsc attrib -r PlatformPkgExtConfig.dsc
@if "%EXT_CONFIG_CLEAR%" == "" (
  @echo.>PlatformPkgExtConfig.dsc
)
@if exist IntelFsp2PkgExtConfig.dsc attrib -r IntelFsp2PkgExtConfig.dsc
@if "%EXT_CONFIG_CLEAR%" == "" (
  @echo.>IntelFsp2PkgExtConfig.dsc
)
@set EXT_CONFIG_CLEAR=
@set EXT_BUILD_FLAGS=

:CmdLineParse
if "" == "%1" (
  goto Continue
) else if "r" == "%1" (
  set PrepRELEASE=RELEASE
) else if "tr" == "%1" (
  set PrepRELEASE=TEST_RELEASE
) else if "rp" == "%1" (
  set PrepRELEASE=RELEASE_PDB
) else if "s" == "%1" (
  set SILENT_MODE=TRUE
) else if "c" == "%1" (
  set CapsuleBuild=TRUE
) else if "rc" == "%1" (
  set PrepRELEASE=RELEASE
  set CapsuleBuild=TRUE
) else if "embedded" == "%1" (
  echo gPlatformModuleTokenSpaceGuid.PcdEmbeddedEnable^|TRUE >> PlatformPkgExtConfig.dsc
) else if "cov" == "%1" (
  echo gPlatformModuleTokenSpaceGuid.PcdCodeCoverageEnable^|TRUE >> PlatformPkgExtConfig.dsc
) else if "fspb" == "%1" (
  echo gPlatformModuleTokenSpaceGuid.PcdFspBinaryEnable^|TRUE >> PlatformPkgExtConfig.dsc
) else if "fspw" == "%1" (
  echo gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable^|TRUE >> PlatformPkgExtConfig.dsc
) else if "pacm" == "%1" (
  echo gPlatformModuleTokenSpaceGuid.PcdStartupAcmBinEnable^|FALSE >> PlatformPkgExtConfig.dsc
) else if "perf" == "%1" (
  echo gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable^|TRUE >> PlatformPkgExtConfig.dsc
) else if "catalogdebug" == "%1" (
  echo gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable^|TRUE >> PlatformPkgExtConfig.dsc
  echo gSiPkgTokenSpaceGuid.PcdSiCatalogDebugEnable^|TRUE >> PlatformPkgExtConfig.dsc
) else if "help" == "%1" (
  goto PrepHelp
) else (
  echo Invalid input arguments: %1
  echo.
  goto PrepHelp
)
SHIFT
goto CmdLineParse

:PrepHelp
@echo Preparation for BIOS build.
@echo.
@echo prep [r][rp][s][c][rc][fspb][tr][fspw][pacm][perf][catalogdebug][help]
@echo.
@echo   r         To do release build. Default is debug build. See note 1
@echo   rp        To do release build with Symbols - For source level debugging. See note 1
@echo   s         To build in silent mode. . See note 1
@echo   c         To build with CapsuleBuild=TRUE (Debug build). See note 1
@echo   rc        To build with CapsuleBuild=TRUE (Release build). See note 1
@echo   cov       To set gPlatformModuleTokenSpaceGuid.PcdCodeCoverageEnable|TRUE. See note 1
@echo   fspb      To build FSP Binary (Default is Debug build, adding r for Release build or tr for Test Release build). See note 1
@echo   fspw      To build FSP Wrapper (Default is Debug build, adding r for Release build). See note 1
@echo   fspb fspw r To build FSP both Binary and Wrapper (Release build). See note 1
@echo   pacm      To set gPlatformModuleTokenSpaceGuid.PcdStartupAcmBinEnable|FALSE. See note 1
@echo   perf      To set gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable|TRUE. See note 1
@echo   catalogdebug To set gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable|TRUE. See note 1
@echo.
@echo 1) Re-running prep without these arguments cannot be used for
@echo    incremental build. Hence, these inputs must be supplied each time
@echo    prep are desired to be re-run.
@echo.
goto PrepDone

:Continue
@echo ==============================================
@echo Dumping PlatformPkgExtConfig.dsc
@type PlatformPkgExtConfig.dsc
@echo ==============================================

if exist %WORKSPACE%\Prep.log del %WORKSPACE%\Prep.log

:PrepReleaseCheck

@if %SILENT_MODE% EQU TRUE goto BldSilent

call prebuild.bat %PrepRelease% %CapsuleBuild%
goto PrePrepDone

:BldSilent
@echo ************************************************************************ >> %WORKSPACE%\Prep.log
@echo ***********           Prebuild.bat is launched here          *********** >> %WORKSPACE%\Prep.log
@echo ************************************************************************ >> %WORKSPACE%\Prep.log
call prebuild.bat %PrepRelease% %CapsuleBuild% 1>>%WORKSPACE%\Prep.log 2>&1

:PrePrepDone
@If %SCRIPT_ERROR% EQU 1 goto PrepFail
@goto PrepDone

:PrepFail
@echo.
@echo !! The EDKII BIOS build has failed in prep!
@echo.
@exit /b 1

:PrepDone